#!/bin/sh

TP_USERNAME_PASSWORD_RESULT_OK="DTAS[TUI]@{OK}"
TP_USERNAME_PASSWORD_RESULT_CANCEL="DTAS[TUI]@{CANCEL}"
TP_USERNAME_PASSWORD_RESULT_ERROR="DTAS[TUI]@{ERROR}"
TP_USERNAME_PASSWORD_RESULT_CODE=""

TP_USERNAME_PASSWORD_RESULT_MSG=""

TP_USERNAME_PASSWORD_RESULT_IP=""
TP_USERNAME_PASSWORD_RESULT_USERNAME=""
TP_USERNAME_PASSWORD_RESULT_PASSWORD=""

tp_username_password() {
	debug_print "in function '${FUNCNAME[0]}'"
	
	local title="${1}"
	local text="${2}"
	local label_ok="${3}"
	local label_cancel="${4}"
    local username="${5}"
    local password="${6}"

	exec 3>&1	
    local ret=`dialog \
        --backtitle     "${CONS_BACK_TITLE}" \
        --title         "${title}" \
        --ok-label      "${label_ok}" \
        --cancel-label  "${label_cancel}" \
        --insecure      \
        --mixedform     "${text}" \
                        "${CONS_BOX_HEIGHT}" \
                        "${CONS_BOX_WIDTH}" \
                        0 \
        "${STRING_USERNAME}" 1  0 "${username}" 1 12 19 18 0 \
        "${STRING_PASSWORD}" 3  0 "${password}" 3 12 41 40 1 \
        2>&1 1>&3; \
        case "${?}" in \
            1|255) echo "${TP_USERNAME_PASSWORD_RESULT_CANCEL}" ;; \
        esac`
	exec 3>&-
	

    ##################################################
    # press "CANCEL" or "ESC"
    ##################################################
    case "${ret}" in
        "${TP_USERNAME_PASSWORD_RESULT_CANCEL}" )
            TP_USERNAME_PASSWORD_RESULT_CODE="${TP_USERNAME_PASSWORD_RESULT_CANCEL}"
            TP_USERNAME_PASSWORD_RESULT_MSG=""
            return
            ;;
    esac

    
    ##################################################
    # collect user-defined information
    ##################################################
    local input_username=`echo "${ret}" | sed -n '1p'`
    local input_password=`echo "${ret}" | sed -n '2p'`

    debug_print "get ip_address from dialog: ${input_ip}"
    debug_print "get username from dialog: ${input_username}"
    
    
    ##################################################
    # check validify
    ##################################################
	
	# username
	if ! $(is_username_valid "${input_username}") ; then
		debug_print "invalid username: ${input_username}"

        TP_USERNAME_PASSWORD_RESULT_CODE="${TP_USERNAME_PASSWORD_RESULT_ERROR}"
        TP_USERNAME_PASSWORD_RESULT_MSG="${TP_USERNAME_PASSWORD_ERROR_INVALID_ARGUMENT}: ${input_username}"
        return
	fi
	
	# password
	if ! $(is_password_valid "${input_password}") ; then
		debug_print "invalid password"

        TP_USERNAME_PASSWORD_RESULT_CODE="${TP_USERNAME_PASSWORD_RESULT_ERROR}"
        TP_USERNAME_PASSWORD_RESULT_MSG="${TP_USERNAME_PASSWORD_ERROR_INVALID_ARGUMENT}: password"
		return
	fi
	
	
	##################################################
	# save
	##################################################
    TP_USERNAME_PASSWORD_RESULT_USERNAME="${input_username}"
    TP_USERNAME_PASSWORD_RESULT_PASSWORD="${input_password}"
    
    TP_USERNAME_PASSWORD_RESULT_CODE="${TP_USERNAME_PASSWORD_RESULT_OK}"
    TP_USERNAME_PASSWORD_RESULT_MSG=""
}

